﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "このプロダクト アクティベーションで収集されたすべてのデータは、オートデスクでの業務処理のみに使用されます。 ";
var xmsgOfflinePrivacyWarning= "インターネットに接続していない場合は、Internet Explorer(R) ブラウザのエンコード設定を「自動選択」にしてプライバシー ポリシーを表示してください。インターネットにアクセスできる場合は、autodesk.com にあるプライバシー ポリシーをご覧いただけます。"
////////////////////////////////////////////////////

var xmsgProductLanguage=	"ja";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"オーソライズは確認されました";
var xmsgRTActLicFound=                  "アクティベーション済みのライセンスが見つかりました";
var xmsgRTActLicFoundError=            "登録/アクティベーション エラー"; 
var xmsgRTAuthEntryError=				"アクティベーション エントリのエラー";
var xmsgRTAuthError=					"アクティベーション エラー";
var xmsgRTAuthNow=						"オーソライズします";
var xmsgRTBeginReg=						"登録を開始";
var xmsgRTBuyInformation=				"購入情報";
var xmsgRTConfirm=						"ユーザ確認";
var xmsgRTConnect=						"接続";
var xmsgRTConnectFail=					"接続エラー";
var xmsgRTContactAutodesk=				"オートデスク ユーザ登録センターに問い合わせる";
var xmsgRTCountryPage=					"国";
var xmsgRTEmail=						"電子メール";
var xmsgRTFaxUS=						"ユーザ Fax US";
var xmsgRTMailUS=						"ユーザ Mail US";
var xmsgRTPurchaseOffline=				"オフライン購入";
var xmsgRTRegConfirmed=					"登録を確認しました";
var xmsgRTExportConfirm=                "ライセンス エクスポートの確認";
var xmsgRTImportConfirm=                "ライセンス インポートの確認"; 
var xmsgRTRegVol=						"登録製品";
var xmsgRTSUNDataConfirm=				"SUN データ確認";
var xmsgRTSUNServer=					"SUN サーバ";
var xmsgRTSUNSubmit=					"ユーザ確認とサブミット SUN";
var xmsgRTUserInfo=						"ユーザ情報";
var xmsgRTLicFileSaveError=				"FLEXnet ライセンス ファイル保存エラー";
var xmsgRTProductInfo=                   "製品情報"; //add by joyce.min on 2007-8-14
var xmsgNSARTBegin=						"ネットワーク ライセンスを取得";
var xmsgNSARTLocateLicense=				"ライセンス ファイルを指定";
var xmsgNSARTEditServerAndSeat=			"サーバ修正情報を入力";
var xmsgNSARTConfirmServerAndSeat=		"サーバ情報を確認";
var xmsgNSARTEnterSN=					"シリアル番号を入力";
var xmsgProcessingError=				"処理エラー";
var xmsgTimeout=        				"このセッションはタイムアウトしました";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"アクティベーション:";
var xmsgPurchase=       "購入:";
var xmsgRegistrationFor=       "登録者:";
var xmsgProduct=	"製品名: ";
var xmsgsernum=		"シリアル番号: ";
var xmsgsernumWGID=	"シリアル番号: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "プロダクト キー: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"旧バージョンのシリアル番号: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"旧バージョンのシリアル番号:*";
var xmsgNewSernum1=	"シリアル番号またはグループ ID を入力:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"リクエスト コード: ";
var xmsgRegAuthCode=	"アクティベーション コード: ";
var xmsgApplicationKey=	"アプリケーション キー: ";
var xmsgRTHostID=				"ホスト ID:";
var xmsgRTFlexlmLicenseFile=	"ライセンス ファイル:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"敬称:";
var xmsgNone=		"(なし)";
var xmsgNotEntered=	"(入力なし)";
var xmsgFirstname=	"名:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"名 (漢字/全角カナ):";
var xmsgFirstnameFurigana=	"名のフリガナ(全角カナ):";
var xmsgLastname=	"姓:";
var xmsgLastnameKanji=	"姓 (漢字/全角カナ):";
var xmsgLastnameFurigana=	"姓のフリガナ(全角カナ):";
var xmsgCompanyName=	"会社名:*";
var xmsgCompanyName2=	"会社名:";
var xmsgCompanyNameJP=	"会社名(漢字) - 数字は半角、カタカナは全角で入力してください(略称 -㈱㈲など- は使用しないでください):";
var xmsgPhone=		"電話番号 - 数字とハイフンを半角で入力してください(例: 市外局番 03、番号　1111-2222):";
var xmsgArea=		"市外局番:";
var xmsgNumber=		"番号:";
var xmsgExt=		"内線:";
var xmsgFax=		"ファックス番号 - 数字とハイフンを半角で入力してください(例: 市外局番 03、番号　1111-2222):";
var xmsgFaxTo=		"FAX の宛先 ";
var xmsgEmail=		"電子メール - 半角英数字で入力してください:";
var xmsgEmailTo=	"電子メールの宛先 ";
var xmsgAddress=	"番地 - 数字とハイフンを半角で入力してください(例: 1-22-333):";
var xmsgAddress2=	"住所 2:";
var xmsgAddress3=	"住所 3:";
var xmsgJPAddress=	"町名 - カタカナは全角で入力してください(例: 晴海):";
var xmsgJPAddress2=	"番地 - 数字とハイフンを半角で入力してください(例: 1-22-333):";
var xmsgJPAddress3=	"ビル名/マンション名 - 数字は半角、カタカナは全角で入力してください(略称 -㈱㈲など- は使用しないでください。該当がない場合は「-」を入力してください):";
var xmsgCity=		"郡/市/町/村/区 - カタカナは全角で入力してください(例: 昭島市、奥多摩郡日の出町、名古屋市栄区、世田谷区、利根郡利根村):";
var xmsgSRP=		"州/地域/県:";
var xmsgStText=		"州:";
var xmsgPrText=		"県:";
var xmsgRegText=	"地域:";
var xmsgPrefectureText=	"都道府県:";
var xmsgCountyText=	"国:";
var xmsgCantonText=	"州:";
var xmsgZipCode=	"郵便番号 - 数字とハイフンを半角で入力してください(例: 123-1111):";
var xmsgPostCode=	"郵便番号 - 数字とハイフンを半角で入力してください(例: 123-1111):";
var xmsgCountry=	"国または地域:";
var xmsgDealer=		"オートデスク認定リセラー名:";
var xmsgMailTo=		"郵送先住所 ";
var xmsgAnEmail=	"電子メール アドレス";
var xmsgAFax=		"FAX 番号";
var xmsgAMailAddress=	"住所";
var xmsgPostalMail=		"郵送";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"<< 戻る";
var xmsgCancel=			"閉じる";
var xmsgNext=			"次へ >>";
var xmsgPrint=			"印刷";
var xmsgPrintForm=		"アクティベーション コード申請書を開く";
var xmsgNo=				"いいえ";
var xmsgYes=			"はい";
var xmsgBrowse=			"参照";
var xmsgDone=			"完了";
var xmsgOK=				"OK";
var xmsgClose=			"閉じる";
var xmsgSubmit=			"送信";
var xmsgFinish=			"完了";
var xmsgReset=			"すべてクリア";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"選択してください ";
var xmsgPleaseSelect2=		"次のいずれかを選択し、[次へ]をクリックしてください。";
var xmsgSelectCountry=		"この製品をお使いになる国または地域を選択:";
var xmsgSelectCountry2=		"国または地域:";
var xmsgInformation=		"情報";
var xmsgCompanyInfo=		"会社情報:";
var xmsgContactInfo=		"担当者情報:";
var xmsgResponseMethodInfo=	"応答方法:"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"申請方法:";
var xmsgConfirmInfo=		"情報の確認";
var xmsgConfirmInfoTxt=		"下記に表示された情報を確認してください。この情報が正しければ次に示す申請方法から 1 つを選択します。変更を行う場合は[戻る]をクリックしてください。";
var xmsgConfirmCustIDInfoTxt=		"下記に表示された情報を確認し、内容が正しければ[次へ]、変更を行う場合は[戻る]をクリックしてください。";
var xmsgCountryHdr=			"製品の登録";
var xmsgCountryRegTo=		"この製品の登録者:";
var xmsgCountryComp=		"法人";
var xmsgCountryIndiv=		"個人";
var xmsgCountryUpgrade=		"この製品がアップグレード版の場合";
var xmsgCountryUpgDetail=	"(お客様が Subscription の契約者である場合は、[いいえ]をクリックしてください)";
var xmsgConnectHdr1=		"接続中";
var xmsgConnectHdr=		"インターネットに接続中";
var xmsgConnectMsg=		"接続";
var xmsgConnectTxt=		"インターネットに接続されていません。オンライン リクエストを送信するには、今ここでインターネットに接続してください。";
var xmsgConnectTxtOLT=    "インターネットに接続されていません。ライセンスを転送するには、今ここでインターネットに接続してください。";
var xmsgConnectTxt2=	"インターネットへの接続が完了したら、[次へ]をクリックしてください。";
var xmsgConnectTxt3=	"リクエストを送信するための他の方法を選択する場合は、次のリンクをクリックしてください:";
var xmsgConnectWarming=	"この情報を送信するのに数分かかることがあります。お待ちください...";
var xmsgTryAgain=		"やり直す";
var xmsgReEnterOld=		"旧バージョンのシリアル番号を入力し直す";
var xmsgNewSernum3=		"新しいシリアル番号を入力し、[次へ]をクリックしてください。";
var xmsgNewSernum4=		"体験版のソフトウェアは、登録できないシリアル番号(000-00000000)でインストールされています。このソフトウェアを購入した場合は、新しいシリアル番号が発行されています。製品を使用可能にするには、そのシリアル番号を使用してアクティベーションを行う必要があります。";
var xmsgNewSernum5=		"シリアル番号を入力:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "プロダクト キーを入力:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"新しいシリアル番号の確認:";
var xmsgNewSernum8=		"新しいシリアル番号を入力し直す";
var xmsgUseOtherMethod=		"他の方法で登録する";
var xmsgContactAutodesk=	"オートデスク ユーザ登録センターに問い合わせる";
var xmsgContactAutodeskLink="オートデスクへお問い合わせになるには、次のリンクをクリックしてください:";
var xmsgContactOptions=		"お問い合わせ方法は次に示す通りです。";

var xmsgPuchaseInfo1=		"購入情報";
var xmsgPuchaseInfo2=		"オンライン購入が選択されました。"; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"続けるには[次へ]をクリックします。操作を中止するには[閉じる]をクリックします。"; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"製品を登録 - アクティベーション";
var xmsgRegTitleBuy=		"オートデスク製品のオンライン購入";
var xmsgRegTitleNSA=		"ネットワーク ライセンス アクティベーション";
var xmsgRegInfo=		"お客様情報";
var xmsgRegInfo2=		"登録方法";
var xmsgRegInfo3=		"登録方法を選択し、[次へ]をクリックしてください。";
var xmsgRegmethod1=		"インターネットで直接接続";
var xmsgRegmethod3=		"アクティベーション コードを次の方法で受け取る:";
var xmsgRegmethod5=		"郵送";
var xmsgRegmethod6=		"下の[印刷]ボタンをクリックし、印刷した申請書を次のオートデスク ユーザ登録センターまで郵送してください。";
var xmsgRegmethod7=		"FAX";
var xmsgRegmethod8=		"オートデスク (%1) に FAX で送信するための申請書を印刷するには、まず、希望するアクティベーション コードの受け取り方法を選択します。次に[印刷]ボタンをクリックし、印刷した申請書を FAX で送信してください。";
var xmsgRegmethod9=		"電子メール";
var xmsgRegmethod10NSA=		"下記に示す登録情報およびライセンス サーバ情報は、自動的にファイルに保存されました。 ";
var xmsgRegmethod10=		"下記に示す登録情報は、自動的にファイルに保存されました。このファイルを使用して電子メールによる登録を完了してください(ファイルの内容を変更しないでください):";
var xmsgRegmethod11NSA=		"登録情報、クライアントのシリアル番号、サーバを含む総ライセンス数、ライセンス サーバ情報ファイル %1 を %2 へ電子メールでお送りください。";
var xmsgRegmethod11=		"登録情報ファイル %1 を %2 へ電子メールでお送りください。";
var xmsgRegmethod12=		"このファイルに対する修正は絶対に行わないでください。<p>このページを印刷し、安全な場所に保管することをお勧めします。また、これらの情報は、電子メールによる処理を行う際に必要になります。<p>このページの情報を印刷して保管してください。[完了]をクリックすると、このアプリケーションは閉じられます。";
var xmsgRegmethod13=		"%1 を自動的に添付してオートデスクに送信するには、次のリンクをクリックしてください。";
var xmsgRegmethod14=		"リクエストを電子メールで送信";
var xmsgRegmethod15=		"注: この電子メール アドレスは受信専用です。このアドレスを通常の連絡用には使用しないでください。";
var xmsgRegmethod16=		"FAX または郵送により登録を行うには、次のリンクをクリックしてください:";
var xmsgRegmethod17=		"電子メール送信エラー";
var xmsgRegmethod18NSA=		"システムが登録情報およびライセンス サーバ情報を自動的に送信するときにエラーが発生しました。";
var xmsgRegmethod18=		"システムが登録情報を自動的に送信するときにエラーが発生しました。";
var xmsgRegmethod19=		"ファイルを手動で電子メールにより送信:";
var xmsgRegmethod20NSA=		"登録情報、クライアントのシリアル番号、サーバを含む総ライセンス数、ライセンス サーバ情報ファイル %1 を %2 へ電子メールでお送りください。";
var xmsgRegmethod20=		"登録情報ファイル %1 を %2 へ電子メールでお送りください。";
var xmsgRegmethod21=		"このファイルの編集は絶対に行わないでください。<p>このページを印刷し、安全な場所に保管しておくことをお勧めします。手動で電子メールによる処理を行う場合に、この情報が必要になります。<p>このページの情報を印刷して保管してください。[完了]をクリックすると、このアプリケーションは閉じられます。";
var xmsgRegAuthInfo=		"アクティベーション";
var xmsgRegAuthInfo1=		"登録の確認";
var xmsgRegExpConfirm=      "ライセンス エクスポートの確認";
var xmsgRegImpConfirm=      "ライセンス インポートの確認";
var xmsgRegAuthInfo2=		"アクティベーション コードを取得(アクティベーション コードをまだお持ちでない場合)";
var xmsgRegAuthInfo3=		"アクティベーション コードを入力(アクティベーション コードを取得済みの場合)"; 
var xmsgRegAuthInfo4=		"次のオプションを選択:";
var xmsgRegAuthInfo4A=		"アクティベーション コードを入力(アクティベーション コードを取得済みの場合)";
var xmsgRegAuthInfo4B=		"アクティベーション コードを入力:"; 
var xmsgRegAuthInfo5=		"国または地域を選択し、アクティベーション コードを入力したら[次へ]をクリックします。";
var xmsgRegAuthInfo6=		"製品を登録 - アクティベーションの確認";	
var xmsgRegAuthInfo7=		"ご登録ありがとうございます。製品のアクティベーションが完了しました。";
var xmsgRegAuthInfo8=		"確認";		
var xmsgRegAuthInfo9=		"オートデスク製品をご登録くださり、ありがとうございました。この登録は今後のサポートに役立ちます。";
var xmsgRegAuthInfo10=		"登録情報を記録したファイルが次の場所に保存されています:";		
var xmsgRegAuthInfo10B=		"登録情報を記録したファイルが次の場所に保存されています:";
var xmsgRegActLicInfo=      "アクティベーション済みのライセンスが見つかりました";
var xmsgRegActLicInfoError=      "登録/アクティベーション エラー";
var xmsgRegActiveInfo=        "アクティベーション ファイルのファイル名を入力または参照:";
var xmsgRegActLicInfo1=       "このコンピュータに、この製品用に以前に登録およびアクティベーションが完了したライセンスが見つかりました。"
var xmsgRegActLicInfo1Error= "このコンピュータに、以前に登録されアクティベートされた製品のライセンスが見つかりました。\n しかし、予期しないエラー(%1)が発生したため、アプリケーションを終了してからやり直してください。この問題が解決されない場合は、システム管理者またはオートデスク認定リセラーに問い合わせてください。";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "エクスポート成功"; //2008-01-16
var xmsgExportFail=           "エクスポート要求の失敗" ; //2008-01-16
var xmsgRegErrRef=            "エラーの参照:"; //2008-01-17
var xmsgImportSuccess=        "インポート成功"; //2008-01-16
var xmsgImportFail=           "インポート要求の失敗"; //2008-01-16
var xmsgExpSucessInfo=        "ライセンスのエクスポートに成功し、オートデスクのサーバに返されました。"; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "ライセンスのインポート方法";
var xmsgExpSucessInfo1=        "転送先のコンピュータで製品を使用するには、ライセンス転送ユーティリティを使用してライセンスを目的のコンピュータにインポートしなければなりません。また、オートデスク製品のログイン ID とパスワードも必要です。";  //2008-01-16
var xmsgImpSucessInfo=         "ライセンスのインポートに成功しました。この製品をご利用いただけます。 "; //2008-01-16
var xmsgImpRemindInfo=         "エクスポートの通知を要求"; //2008-01-16
var xmsgImpRemindInfo1=        "このオプションをオンにすると、アプリケーションを終了するたびにライセンスをエクスポートするように通知するダイアログ ボックスが表示されます。";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "これは、一時的にこのコンピュータにライセンスをインポートし、あとでライセンスを返却しなければいけない場合に便利です。";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "「次回からこのメッセージを表示しない」のオプションも設定できます。";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "リクエストを再送信するには、「やり直す」リンクをクリックしてください。 ";
var xmsgImpFailMsg=            "問題が解決されない場合は、ライセンスをインポートするのではなく、アクティベートします。";

var xmsgReqfilelocMsg=       "要求ファイルの保存場所:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"オートデスク製品をご登録くださり、ありがとうございました。アクティベーションが完了し、ライセンス ファイルが保存されました。[印刷]をクリックしてこのページの情報を保管してください。";
var xmsgRegAuthInfo12=		"アクティベーション コードを貼り付けます。";
var xmsgRegAuthInfo13=		"アクティベーション コードを入力します。";
var xmsgRegErrorActiveCode=    "<FONT color=red>続けるにはアクティベーション コードを入力してください。</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>アクティベーション コードが無効です。エラー コードを確認してください。</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>続けるにはアクティベーション ファイルのパスとファイル名を入力してください。</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>続けるにはシリアル番号を入力してください。</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>シリアル番号が短すぎます。</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>続けるにはプロダクト キーを入力してください。</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>プロダクト キーが短すぎます。</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"登録/アクティベーション エラー";
var xmsgRegErrorSystem=		"登録の際にシステムに一時的なエラーが発生しました。次のリンクのいずれかをクリックしてください。"
var xmsgRegErrorPrevReg=	"入力したシリアル番号は既に登録されています。";
var xmsgRegErrorMaxAuth=	"この製品に許可されたアクティベーション数を超えました。";
var xmsgRegErrorMaxAuth2=	"この製品に許可されたライセンス数を超えました。";
var xmsgRegErrorInvalidOld=	"入力された旧バージョンのシリアル番号は有効ではありません。表示されている旧バージョンのシリアル番号が正しいか確認してください。次のリンクのいずれかをクリックしてください。";
var xmsgRegErrorData=		"入力された登録情報に問題があります。[やり直す]をクリックして入力したデータが正しいかを確認してください。他の登録方法を選択することもできます。不明な場合はオートデスクにお問い合わせください。";
var xmsgRegErrorNetwork=	"登録しようとしている製品は、ネットワーク インストレーション用に提供されている製品であり、そのようにインストールする必要があります。ソフトウェアをアンインストールし、インストレーションの種類として \"ネットワーク\" を選択してください。『AutoCAD インストレーション ガイド』のネットワーク インストレーションの章を参照してください。";
var xmsgRegNoResponse=		"オンライン登録の際にシステムに一時的なエラーが発生しました。次のリンクのいずれかをクリックしてください。";
var xmsgRegErrorAuthEntry=	"入力されたアクティベーション コードに問題があります。次のリンクのいずれかをクリックしてください。";
var xmsgRegErrorAuthPermission = "このオートデスク製品のアクティベーションを行うには、システム管理者としてログインするか、管理者権利を持つユーザとしてログインしなければなりません。管理者権利に関する詳細は、システム管理者に問い合わせてください。";							
var xmsgRegErrorAuth=		"アクティベーション コードに問題があります。次のリンクのいずれかをクリックしてください。";
var xmsgRegErrorFlex=		"ライセンスに問題があります。次のリンクのいずれかをクリックしてください。";
var xmsgRegConnError=		"接続エラー";
var xmsgRegConnErrorTxt=	"インターネット接続に問題があります。次のリンクのいずれかをクリックしてください。";
var xmsgRegPurchError3=		"他の方法で購入する";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "オートデスク製品をご選択いただきありがとうございます。<p>お使いのコンピュータの設定の影響で、現在はこの処理を完了することができません。<p>次に示すいずれかのリンクをクリックしてください。ブラウザが開き、接続に成功できる可能性があります。<p>";

var xmsgAuthResellerMsg1=	"最寄のオートデスク認定リセラーでご購入ください。購入を完了するには、オートデスク認定リセラーへお問い合わせください。";

var xmsgLicSaveErrInfo=		"ライセンス ファイルの保存時にエラーが発生しました。次のリンクのいずれかをクリックしてください。";

var xmsgOnlineStoreMsg1=	"オートデスク オンライン ストアでご購入ください。ご希望の製品が見つからない場合は、オートデスク認定リセラーへお問い合わせください。";
var xmsgOnlineStoreMsg2=    "オンライン ストア";
var xmsgAuthResellerMsg2=	"オートデスク認定リセラー";
var xmsgLocateLicenseMsg1=	"ライセンス ファイルを指定";
var xmsgLocateLicenseMsg2=	"ライセンス ファイルのパスを指定(または[参照]を使って選択)し、[次へ]をクリックしてください。";
var xmsgLocateLicenseMsg3=	"既存のライセンス ファイル:";
var xmsgUserContactMsg=		"次のうちから少なくとも 1 つ選択してください:";
var xmsgFailureMsg=		    "お客様のオンライン アクティベーション申請は処理されませんでした。";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "お客様のアクティベーション申請でエラー(%1)が発生したため、自動化されたシステムによる処理を行えません。";
var xmsgRegErrorOnline=		"［別の申請方法を選ぶ］をクリックし、電子メール、ファックス、その他の申請方法をお選びください。";
var xmsgAnotherFormSubmitMethod=    "別の申請方法を選ぶ";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "お客様のオンラインでの アクティベーション コード申請はタイムアウトしました。"
var xmsgTimeoutMsg2=    "オンライン リクエストを送信するには、[やり直す]リンクをクリックしてください。問題が解決しない場合は、[別の方法を使用する]をクリックすることにより、電子メール、FAX または郵送などの手段によりリクエストを送付することができます。";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"登録情報の保存";
var xmsgRegSunData2=		"クライアント配置に必要な登録情報は、次の場所に保存されました: ";
var xmsgRegSunData3=		"このアップグレードの登録のために入力された旧バージョンのシリアル番号は、有効ではありません。シリアル番号を再度ご確認ください。";
var xmsgRegSunData4=		"このソフトウェアは、有効な旧バージョンのシリアル番号を使用して再インストールする必要があります。";
var xmsgRegSunData5=		"マルチシート スタンドアロン(サブスクリプション ユーザのみ使用可能)";
var xmsgRegSunData6=		"マルチシート スタンドアロン インストレーションを行うために、いくつかの情報を登録する必要があります。以降のページで次のことを行います:";
var xmsgRegSunData7=		"必要事項を入力";
var xmsgRegSunData8=		"アップグレード版の場合は、前バージョンのシリアル番号を入力";
var xmsgRegSunData9=		"すべてのクライアント インストレーションにへ配置するために、この情報をサーバに保存";
var xmsgRegSunData10=		"このソフトウェアは、次の情報を使用して登録されます。続けるには[次へ]をクリックしてください。";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"製品の登録";
var xmsgRegVol2=	"次のオプションのいずれかを選択し、[次へ]をクリックしてください。";
var xmsgRegVol3=	"今すぐ登録 - オンライン登録を開始するには、このオプションを選択してください";
var xmsgRegVol4=	"後で登録 - ソフトウェアを今すぐ実行するには、このオプションを選択してください";
var xmsgRegVol5=	"次回からこのメッセージを表示しない。";
var xmsgRegVol6=	"(後で登録する場合は、[ヘルプ]メニューから[バージョン情報]を選択し、ダイアログで登録オプションを選択してください)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"ユーザ情報";
var xmsgKatakana=		    "会社名フリガナ(全角カナ):";
var xmsgDepartment=		    "部署名 - 数字は半角、カタカナは全角で入力してください:";
var xmsgDepartment2=		"部署名 - 数字は半角、カタカナは全角で入力してください:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"インターネット:";
var xmsgFormWebDataMsg1= "アクティベーションコードの申請は、次のサイトから行うこともできます:<br>";
var xmsgFormEmailHdr=	"電子メール - 半角英数字で入力してください:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"ファックス番号 - 数字とハイフンを半角で入力してください(例: 市外局番 03、番号　1111-2222):";
var xmsgFormFaxHdrLocal=	"FAX ローカル オフィス:";
var xmsgFormFaxHdrReg=	"FAX による登録:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"電話番号 - 数字とハイフンを半角で入力してください(例: 市外局番 03、番号　1111-2222):";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"郵送:";
var xmsgFormMailHdrLocal=	"郵送ローカル オフィス:";
var xmsgFormMailHdrReg=	"郵送による登録:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"ソフトウェア購入";
var xmsgFormInternetMsg=    "アクティベーション コードのリクエストを Web ブラウザで行うには、リンクをクリックしてください。"
var xmsgFormEmailMsg=       "電子メールによるアクティベーション リクエストの送付先:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "オートデスクでは、ご提供いただく情報を登録やアクティベーション　コードの発行時に使用します。この登録により、お客様は、オートデスクがお客様の情報を、製品のライセンスを管理する目的及び権利付与を検証する目的で、オートデスク認定リセラー等に提供することについての同意を明確にします。オートデスク認定リセラー等に情報が提供されることを望まれない場合は、<a href=mailto:information@autodesk.co.jp target=\"_blank\">information@autodesk.co.jp</a> にご連絡ください。登録データの修正または更新が必要な場合は、<a %1>ここ</a> をクリックするか、オートデスクにお問い合わせください。";
			
var privacystatement = "オートデスクでは、ご提供いただく情報を登録やアクティベーション　コードの発行時に使用し、お客様に製品とサービスについてのお知らせや、オートデスクの認定ユーザの特典を提供するために活用させていただきます。上記の目的の範囲内で、お客様の情報をオートデスク認定リセラー等に提供することがあります。オートデスク認定リセラー等に情報が提供されることを望まれない場合は拒否が可能ですので、電子メール、電話などの方法でオートデスクにご連絡ください。連絡先はオートデスクホームページをご覧ください。 登録済みの情報に変更や更新がある場合は、<a %1>ここ</a> をクリックするか、オートデスクにお問い合わせください。";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="プライバシー ポリシー";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(C) Copyright 2009 Autodesk, Inc. All rights reserved."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="通常、管理者権限を持つユーザ アカウントでログオンし、製品を再起動しないと、新しいシリアル番号は表示されません。";
var xmsgRebranding2="管理者権限でプログラムを起動する方法の詳細については、オペレーティング システムのヘルプを参照してください。";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "<FONT color=red>*</FONT> の付いた項目は必須の入力項目です。";
var xmsgRegInfoMsg2= "このページに入力された情報は、ライセンス情報とともに保存されます。これらの情報は製品の再アクティベーションとアップグレードの際に使用されます。製品の登録とご利用の際に支障が生じないよう、正確な情報が記載されていることをご確認ください。";

var xmsgLicLocationText1 = "<b>%1</b> 用のライセンスの保存先:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"アンケート項目:";

var xmsgAppUsageQ1=	"お客様の所属する産業におけるニーズをより詳しく理解するために、次の簡単なアンケートにご協力ください。";
var xmsgAppUsageQ2=	"貴社の業種に最も近い分野を選択してください";

var xmsgAppUsageOption51=	"航空宇宙産業および自動車部品設計 ";
var xmsgAppUsageOption52=	"建築設計 ";
var xmsgAppUsageOption53=	"建物/施設管理 ";
var xmsgAppUsageOption54=	"建物建設: 商業施設 ";
var xmsgAppUsageOption55=	"建物建設: 住居 ";
var xmsgAppUsageOption56=	"建物設備製造 ";
var xmsgAppUsageOption57=	"土木設計/土地計画 ";
var xmsgAppUsageOption58=	"コンピュータ/医療機器/オフィス機器設計 ";
var xmsgAppUsageOption67=	"消費者向け製品デザイン ";
var xmsgAppUsageOption59=	"オフィス ビルディング所有/管理 ";
var xmsgAppUsageOption92=	"防衛関連 ";
var xmsgAppUsageOption93=	"電子制御設計 ";
var xmsgAppUsageOption94=	"電機システム ";
var xmsgAppUsageOption72=	"環境産業 ";
var xmsgAppUsageOption95=	"板金/プレス ";
var xmsgAppUsageOption96=	"インテリア デザイン ";
var xmsgAppUsageOption97=	"機械/装置設計 ";
var xmsgAppUsageOption98=	"資材調達/営業/マーケティング ";
var xmsgAppUsageOption40=	"地図設計/地理情報 ";
var xmsgAppUsageOption41=	"メカニカル システム設計(空調/配管) ";
var xmsgAppUsageOption42=	"配管/防火システム産業 ";
var xmsgAppUsageOption43=	"化学/発電プラント設計 ";
var xmsgAppUsageOption44=	"土地開発 ";
var xmsgAppUsageOption45=	"構造設計 ";
var xmsgAppUsageOption87=	"電気通信 ";
var xmsgAppUsageOption46=	"金型/切削加工 ";
var xmsgAppUsageOption47=	"輸送装置設計 ";
var xmsgAppUsageOption48=	"公共事業: 電気、石油、ガス ";
var xmsgAppUsageOption49=	"公共事業: 上水/下水 ";
var xmsgAppUsageOption99=	"その他 ";

var xmsgWrongCountryCodeMsg=	"エラー: 入力された国コードは無効です!";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "バージョン:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"FAX または電話で申請する"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"郵送による登録";
var xmsgAccessHereMsg=		"ここをクリック。";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "次の方法でコードを取得:";
var xmsgReceiveCodeMsg1=     "アクティベーション ファイルを電子メールで受信する"; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"ライセンスを確認しています。<br>お待ちください";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "製品情報"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "すべてのフィールドに入力が必要です。"; //add by joyce.min on 2007-8-14
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"ネットワーク ライセンスを取得";
var xmsgNSARTBeginMsg1=		"次の方法でネットワーク アクティベーション ファイルを取得:";
var xmsgNSARTBeginMsg2=		"インターネットで直接接続";
var xmsgNSARTBeginMsg3=		"電子メール、FAX、電話、または郵送で申請する";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"サーバ情報";
var xmsgEditServerHdrMsg2=	"ライセンス サーバ モデル*";
var xmsgEditServerMsg1=		"ライセンス サーバ情報を入力してください。<br>[ルックアップ]ボタンをクリックすると、ホスト ID フィールドに値がコピーされます。<p>";
var xmsgEditServerMsg2=		"既存のライセンス ファイルを使用してサーバ ホスト データを開始。";
var xmsgEditServerRemove=	"除去";
var xmsgEditServerHostName=	"サーバ ホスト名*";
var xmsgEditServerHostID=	"ホスト ID*";
var xmsgEditServerSeat=		"シート数*";
var xmsgEditServerSingle=	"シングル サーバ";
var xmsgEditServerDistributed=	"分散サーバ";
var xmsgEditServerRedundant=	"冗長サーバ";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"ルックアップ";
var xmsgEditServerAddServer=	"追加";
var xmsgEditServerRemoveServer=	"除去";
var xmsgEditServerTotal=	"合計:";
var xmsgEditServerExceedMaxServer=	"注: 一度に 20 個までの分散サーバをライセンスできます。20 以上のライセンスが必要な場合は、オートデスクへお問い合わせください。";
var xmsgEditServerSeatError=	"シート数には数値のみを入力してください。";

var xmsgConfirmServerMsg=	"入力された情報を確認してください。継続するには[次へ]、変更を行うには[戻る]をクリックしてください。";
var xmsgConfirmServerMsg2=	"[次へ]をクリックすると、この情報はインターネットを経由してオートデスクに送信されます。";
var xmsgConfirmServerHdr2=	"ライセンス サーバ モデル:";
var xmsgConfirmServerHostName=	"サーバ ホスト名";
var xmsgConfirmServerHostID=	"ホスト ID";
var xmsgConfirmServerSeat=		"シート数";
var xmsgConfirmServerTotal=		"シート数の合計:";

var xmsgLicErrorHdr=			"ライセンス エラー"; 
var xmsgLicErrorInvalidSN=		"入力したシリアル番号は有効ではありません。表示されているシリアル番号が正しいか確認してください。次のリンクのいずれかをクリックしてください。";
var xmsgLicReEnterSN=			"シリアル番号を再入力し、もう一度行ってください。";

var xmsgLic113Msg2=				"分散サーバに割り当てたシート数の合計がその数を超えています。";
var xmsgLic113ModifySeats=		"シート数の分配を修正してください。";

var xmsgSaveLicenseHdr=			"ライセンスを受信";
var xmsgSaveLicenseMsg1=		"オートデスクからのライセンスを受信しました。ライセンス ファイルとして保存してください。<p> <b>ライセンス ファイルの保存</b><p><LI>ライセンス ファイルの保存場所として<b>お勧めする場所</b>は、Autodesk Network License Manager をインストールしたサーバの \"Licenses\" フォルダです。&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>お客様が<b>既存のライセンス ファイル</b>をお持ちの場合は、新しいライセンスをそのファイルに<b>挿入</b>してください。<br>[次へ]をクリックすると、システムが自動的に、ライセンス情報を適切な場所に保存されている既存のファイルに挿入します。</LI>";
var xmsgSaveLicenseMsg2=		"上記で示すファイルが既存のライセンス ファイルの場合:";
var xmsgSaveLicenseMsg3=		"新しいライセンス情報をその中に挿入してください。";
var xmsgSaveLicenseMsg4=		"既存のライセンス ファイルを上書きしてください。";
var xmsgSaveLicenseMsg5=		"次のエラーを修正してください:";

var xmsgSaveErrorFileNameTooLong=  "エラー: 入力したファイル名が長すぎます。<br>" +
								"ファイル名を変更して操作を続けてください。";
var xmsgSaveErrorNoPermission=	"エラー: 指定した場所にファイルを保存するための権利を持っていません。<br>このファイルを一時的に別の場所に保存し、書き込み権利を得たあとで正しい場所に移動してください。";
var xmsgSaveErrorNoDiskSpace=	"エラー: 指定した場所にファイルを保存するには、ディスクの空き容量が足りません。<BR>このファイルを一時的に別の場所に保存し、ディスク容量を確保したあとで正しい場所に移動してください。";
var xmsgSaveErrorInvalidFile=	"エラー: 指定したファイルに新しいライセンスを追加できませんでした。指定したファイルは異なるコンピュータ上にあるか、異なるサーバ モデルである可能性があります。<BR>この新しいライセンスを異なる名前で、または異なる場所に保存し、手作業により正しいファイルに追加してください。";															
var xmsgSaveErrorPathNotExit=	"エラー: 指定したパスは存在しません。<BR>[参照]ボタンをクリックして、正しいパスを指定してください。";
var xmsgSaveErrorPathBlank=		"エラー: 正しいパスとライセンス ファイル名を指定する必要があります。下記のフィールドで正しいパスとライセンス ファイル名を指定するか、[参照]を使って指定してください。";

var xmsgLicAuthConfirmHdr1=		"ライセンスのアクティベーションに成功しました!";
var xmsgLicAuthConfirmHdr2=		"ライセンス サーバ ホスト情報";
var xmsgLicAuthConfirmMsg1=		"製品をご登録いただき、ありがとうございます。必要に応じて、この情報を印刷して保管してください。";
var xmsgLicAuthConfirmDate=		"日付:";

var xmsgLicPathMsg1=			"次のライセンス ファイルが保存されました: ";
var xmsgLicPathMsg2=			"ライセンス ファイルは次の場所に保存されました: ";

var xmsgOtherMethodMsg1NSA=		"ライセンス取得のために別の方法を利用したい場合は、ここをクリックしてください。";
var xmsgOtherMethodMsg1=		"別の方法を利用";

var xmsgContactAutodeskMsg1=	"次の方法でオートデスクにお問い合わせください。";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"電子メールによるライセンス ファイルの取得";
var xmsgEmailOptionTitle=		"電子メールによる登録";
var xmsgEmailOptionNSAMsg=		"お客様の登録情報とライセンス サーバ情報は自動的にファイルへ保存されました。このファイルをオートデスクの登録処理センターへ送信していただく必要があります。<p>電子メールがオートデスクへ届くと、自動応答およびオーソライズされたライセンス ファイル、そしてこの処理を完了するための操作手順がお客様の電子メール アドレスに送信されます。";
var xmsgEmailOptionMsg=			"お客様の登録情報は自動的にファイルへ保存されました。このファイルをオートデスクの登録処理センターへ送信していただく必要があります。<p>電子メールがオートデスクへ届くと、自動応答およびこの処理を完了するための操作手順がお客様の電子メール アドレスに送信されます。";
var xmsgEmailOptionMsg2=		"現在セットアップしている電子メール システムで電子メールを送信可能な場合は、[ファイルを直ちに送信]をクリックし、[次へ]を選択してください。ファイルは自動的に送信されます。<p>電子メールを送信することができない場合は、[ファイルをあとで手動で送信]をクリックしてください。手動でファイルを送信するための操作手順が示されます。";
var xmsgEmailOptionInfo1=		"ファイルを直ちに送信";
var xmsgEmailOptionInfo2=		"ファイルをあとで手動で送信";
var xmsgEmailOptionInfo3=		"記載した電子メール アドレスへメールのコピーを送信";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"電子メールを作成できません";
var xmsgEmailErrorMsg1=			"電子メールによる登録を完了するには、次のファイルをメールに添付してください:";
var xmsgEmailErrorMsg2=			"%1 に電子メールを送信。";
var xmsgEmailErrorMsg3=			"ファイルは次の場所に保存されています:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"お客様情報を変更";
var xmsgLocalHEREInfo=			"お客様情報を変更するには、ご利用いただいたオートデスク認定リセラーへお問い合わせになるか、次の地域別のリンクを使用してください。";
var xmsgLocalHEREUS=			"アメリカ";
var xmsgLocalHEREEMEA=			"ヨーロッパ、中東、アフリカ";
var xmsgLocalHEREAPAC=			"アジアパシフィック";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"ヘルプ";
var xmsgHelpUpgradeMsg=			"お客様が旧バージョンからのアップグレード製品の登録とアクティベーションを行う場合は、このボックスをクリックすることにより旧バージョンのシリアル番号を入力するための項目を表示できます。";
var xmsgHelpUpgradeRequiredTitle=	"旧バージョンの製品シリアル番号を入力(アップグレードに必須)";
var xmsgHelpUpgradeRequiredMsg=	"ここには旧バージョンのシリアル番号を入力します。旧バージョンのシリアル番号は、起動中の製品で[ヘルプ]-[バージョン情報]を選択するか、旧製品パッケージに貼付されています。";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"%1 が入力されていません。この方法でアクティベーション コードを取得したい場合は、必ず入力してください。";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "シリアル番号"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "シリアル番号はパッケージに貼付されています。あるいは製品のアップグレードとライセンス情報の電子メールに記載されています。"; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "プロダクト キー";
var xmsgHelpProductKeyMsg=    "プロダクト キーはパッケージに貼付されたシリアル番号のラベルに記載されています。あるいは製品のアップグレードとライセンス情報の電子メールに記載されています。"; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"接続エラー (0.15)";
var xmsgRT010203071213CannotCompErrA=	"登録エラー (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"既に登録されています (9)";
var xmsgRT10ExceededAuths=				"オーソライズの範囲外 (10)";
var xmsgRT12StolenSN=					"盗難されたシリアル番号 (12)";
var xmsgRT18OldSNInvalid=				"旧バージョンのシリアル番号は無効です (18)";
var xmsgRT20DataError=					"データ エラー (20)";
var xmsgRT21CustIDTelErr=				"お客様側の ID または電話回線のエラー (21)";
var xmsgRT22NetworkInstallation=		"ネットワーク インストレーション エラー (22)";
var xmsgRT900SystemNotResponding=		"システムが応答しません (900)";
var xmsgRTCustID=						"ユーザ ID";
var xmsgRTCustIDConfirm=				"ID の確認";
var xmsgRTNewSerialNumber=				"新しいシリアル番号情報";
var xmsgRTNoNewSN=						"購入処理エラー";
var xmsgRTPurchAuthFailed=				"アクティベーション エラー";
var xmsgRTPurchConfirmOther=			"購入の確認";
var xmsgRTPurchConfirmPerm=				"購入の確認 - 登録とアクティベーションが完了";
var xmsgRTPurchConfirmReg=				"購入の確認 - 登録完了、未アクティベーション";
var xmsgRTPurchConfirmRegVol=			"購入の確認 - 登録完了";
var xmsgRTPurchConfirmRent=				"購入の確認 - 登録完了、リース期間有効";
var xmsgRTPurchConfirmUnReg=			"購入の確認 - 登録とアクティベーションは未処理";
var xmsgRTPurchConnectionFailed=		"購入接続が失敗しました";
var xmsgRTPurchaseError=				"購入エラー";
var xmsgRTSNMismatch=					"購入処理エラー - シリアル番号が一致しません";
var xmsgRTSUNOldSNInvalid=				"旧バージョンのシリアル番号は無効です - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"終了";

var xmsgCustIDMainTitle=	"ユーザ情報";
var xmsgCustIDTitle1=		"ユーザ ID:";
var xmsgCustIDText2=		"下のボックスにユーザ ID と電話番号を入力してください。ユーザ ID を持っていないお客様、または Autodesk Subscription に加入しているお客様は、両方のボックスを空白にしたまま[次へ]をクリックしてください。<p> ";
var xmsgCustIDText3=		"注: ユーザ ID は既にお持ちの製品をユーザ登録された際、オートデスク ユーザ登録センターよりご連絡している番号です。ユーザ ID を入力することで登録情報の入力を簡略することができます。製品の再アクティベーションを行う場合は、ユーザ ID を入力する必要があります。";
var xmsgCustIDText3NSA=		"注: ユーザ ID は既にお持ちの製品をユーザ登録された際、オートデスク ユーザ登録センターよりご連絡している番号です。ユーザ ID を入力することで登録情報の入力を簡略することができます。製品の再オーソライゼーションを行う場合は、ユーザ ID を入力する必要があります。";
var xmsgCustIDTitle2=		"電話番号 - 数字とハイフンを半角で入力してください(例: 市外局番 03、番号　1111-2222):";
var xmsgCustIDTelEx4=		"(例: 03-1111-1234)";
var xmsgRegCustIDTel=		"入力されたユーザ ID または電話番号が間違っています。次のリンクのいずれかをクリックしてください。";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"登録情報によると、お客様は %1 個の有効な %2 シートをお持ちです。<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"入力されたシリアル番号は無効です";
var xmsgErr12APAC=				"<p>入力されたシリアル番号は無効なため、アクティベーションを行えません。 " +
								"次の問合せ先にご連絡ください: " +
								"<a href=mailto:japan.register@activation.autodesk.com target=\"_blank\">japan.register@activation.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>お客様各位</p>" +
								"<p>オートデスクのソフトウェア製品をご登録いただきまして大変ありがとうございます。</p>" +
								"<p>恐れいりますが、登録なさろうとしたオートデスクソフトウェア製品のシリアル番号は、"+
								"有効なシリアル番号ではありません。"+
								"あるいは、既知の不正コピーのシリアル番号と一致するため、" +
								"ご使用中のオートデスク ソフトウェア製品は正規の製品ではありません。</p>" +
								"<p>オートデスク ソフトウェア製品を使用するためのライセンスは、オートデスクの認定リセラーでご購入いただけます。" +
								"お近くのオートデスク認定リセラーおよびオートデスク事業所の一覧は、" +
								"<a href=\"http://www.autodesk.co.jp\" target=\"_blank\">www.autodesk.co.jp</a> " +
								"でご確認ください。" +
								"ソフトウェアを合法的にご利用いただくことにより、そのソフトウェアの使用による最大限の利益を" +
								"享受することができ、ソフトウェアを違法に使用または複製していた場合に" +
								"起こりうる民事訴訟または刑事訴訟を回避することができます。</p>" +
								"<p>オートデスク メディア＆エンターテイメント ソリューション製品の" +
								"認定リセラーの一覧は、" +
								"<a href=\"http://www.autodesk.co.jp/me-resellers\" target=\"_blank\">www.autodesk.co.jp/me-resellers</a> " +
								"でご確認下さい。" +
								"ソフトウェアを合法的にご利用いただくことにより、そのソフトウェアの使用による最大限の利益を" +
								"享受することができ、ソフトウェアを違法に使用または複製していた場合に" +
								"起こりうる民事訴訟または刑事訴訟を回避することができます。</p>" +
								"<p>お客様がオートデスクに登録を試みた不正なシリアル番号の使用をただちに中止し、" +
								"コンピュータ ハードウェアからすべての不正なソフトウェアをアンインストールし、" +
								"かつそのソフトウェアが保存されている媒体を破棄いただくようお願い申し上げます。" +
								"これに応じていただけない場合、オートデスクからビジネス ソフトウェア アライアンス(BSA)" +
								"およびオートデスクの弁護士にお客様の情報を通知する可能性があります。</p>" +
								"<p>ご質問がある場合、またはこのメッセージを不当に受信された" +
								"場合は、" + //modify the e-mail address by joyce.min on 2007-9-3 as the Raptro recommend
								"<a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">emea.register@activation.autodesk.com</a>までお問い合わせください。</p>" +
								"<p>ソフトウェアの不正コピーの使用や販売に関する情報は、" +
								"お近くのオートデスク事業所もしくは BSA" +
								"<a href=\"http://www.BSA.or.jp\" target=\"_blank\">www.BSA.or.jp</a>までご連絡ください。</p>" +
								"<p>よろしくお願いいたします。</p>";
var xmsgErr12US=				"<p>お客様各位</p>" +
								"<p>オートデスクのソフトウェア製品をご登録いただきまして大変ありがとうございます。</p>" +
								"<p>恐れいりますが、登録なさろうとしたオートデスクソフトウェア製品のシリアル番号は、" +
								"有効なシリアル番号ではありません。" +
								"あるいは、既知の不正コピーのシリアル番号と一致するため、" +
								"ご使用中のオートデスク ソフトウェア製品は正規の製品ではありません。</p>" +
								"<p>オートデスク ユーザがオートデスク ソフトウェア製品を使用するためのライセンスは、" +
								"オートデスク認定リセラーでご購入いただけます。お近くのオートデスク認定リセラーの一覧は、" +
								"<a href=\"http://www.autodesk.co.jp\" target=\"_blank\">www.autodesk.co.jp</a> " +
								"でご確認ください。" +
								"ソフトウェアを合法的にご利用いただくことにより、そのソフトウェアの使用による最大限の利益を" +
								"享受することができ、ソフトウェアを違法に使用または複製していた場合に" +
								"起こりうる民事訴訟または刑事訴訟を回避することができます。</p>" +
								"<p>オートデスク メディア＆エンターテイメント ソリューション製品の" +
								"認定リセラーの一覧は、" +
								"<a href=\"http://www.autodesk.co.jp/me-resellers\" target=\"_blank\">www.autodesk.co.jp/me-resellers</a> " +
								"でご確認下さい。" +
								"ソフトウェアを合法的にご利用いただくことにより、そのソフトウェアの使用による最大限の利益を" +
								"享受することができ、ソフトウェアを違法に使用または複製していた場合に" +
								"起こりうる民事訴訟または刑事訴訟を回避することができます。</p>" +
								"<p>お客様がオートデスクに登録を試みた不正なシリアル番号の使用をただちに中止し、" +
								"コンピュータ ハードウェアからすべての不正なソフトウェアをアンインストールし、" +
								"かつそのソフトウェアが保存されている媒体を破棄いただくようお願い申し上げます。" +
								"これに応じていただけない場合、オートデスクからビジネス ソフトウェア アライアンス(BSA)" +
								"およびオートデスクの弁護士にお客様の情報を通知する可能性があります。</p>" +
								"<p>ご質問がある場合、またはこのメッセージを不当に受信された" +
								"場合は、" +
								"<a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a>までお問い合わせください。</p>" +
								"<p>ソフトウェアの不正コピーの使用や販売に関する情報は、" +
								"お近くのオートデスク事業所もしくは BSA" +
								"<a href=\"http://www.BSA.or.jp\" target=\"_blank\">www.BSA.or.jp</a>までご連絡ください。</p>" +
								"<p>よろしくお願いいたします。</p>";






// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFLNFzU6TQTU3
// SIG // k96gqye2q/YCdICboIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFEUdIClt+oIqexLbsbJNPe213sl9MFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYAP
// SIG // R5jr05r0o5ouK6lZ+/PvCa9Faglbzh1VVIdM9jqBL990
// SIG // q7Jtveoi6A7WeNwFbUz4EIQxJciPbf25p3YOA0g2pl9c
// SIG // k2S2IK8Jqoj/X7ukQx6sWaSb/sR9FWOcZ/mLfMZo3q1k
// SIG // mN8rt+Lp6hMpo/GAcPrUdbVLugxGGfoGeRiG66GCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMyODU4
// SIG // WjAjBgkqhkiG9w0BCQQxFgQUKumMTNClXqq8wCoDaKX8
// SIG // /ys+YbEwDQYJKoZIhvcNAQEBBQAEgYB6/LKvI6ak00lc
// SIG // HDa8TIQs5Em6CVDqxqrX8oSIgO53vQUbMZ4oZkaq91zJ
// SIG // Yj0B6t4JYlqylURt9crmCOY+jk6uTyEuEevUaojzTyG9
// SIG // vhWZWNuXZLX2dzPN0U4wqNHY6AeY6KImzGW+rQfyJnsk
// SIG // xr7APJAZvSZm3hSjeCkMHIXYYA==
// SIG // End signature block
